<?php
/** Code Revision
* 18-06-2025:- Updated the code to handle sierratec_enquiries table
* 01-07-2025:- Updated the code to display IP details seperately in the listing for New Enquiry.
* 13-07-2025:- Updated the code to handle the Submitted Date IST filter in New Enquiry.
*/

class listItems
{
	var $tablename;
	var $tname;
	var $searchtext;
	var $sqlstr;
	var $datafields;
	var $headers;
	var $title;
	var $align;
	var $maxlength;
	var $orderbyfield;
	var $order;


	/**
	 * Parsing query of the selected table
	 * @param String $tablename Name of the table passed
	 * @return void
	 */	
	function setIndex($tablename)
	{		
	
		switch($tablename)
		{			
			case 'sierratec_question' : $this->setquestion(); break;
			case 'sierratec_jobs' : $this->setjobs(); break;
			case 'sierratec_applicants' : $this->setapplicants(); break;
			case 'sierratec_subscribers' : $this->setsusbcribers(); break;
			case 'sierratec_enquries' : $this->setenquries(); break;		
			case 'sierratec_postresume_applicants' : $this->setjobapplicants(); break;			 		
			case 'sierratec_xamarin' : $this->setxamarin(); break;
			case 'sierratec_enquiries' : $this->setEnquiries(); break;			 
			case 'sierratec_appointment_booking':
    $this->setappointmentbooking();
    break;

		}	
	}
		
/**
 * Parsing query of Frontpage table and display the records in the grid
 * @param void
 * @return void
 */
	function setquestion() 
	{

		$this->title="Question Search";
		$this->tname="Question";		
		$this->sqlstr="select id,question_desc from sierratec_question where predefined = 'n'";
		
		$this->headers[0]="Question Id";
		$this->headers[1]="Question Desc";

		$this->align[0]="left";
		$this->align[1]="left";

		$this->datafields[0]="id";
		$this->datafields[1]="question_desc";

		$this->maxlength[0]=10;
		$this->maxlength[1]=40;

		$this->orderbyfield="id";
		$this->order="asc";
	}	
	
	function setjobs() 
	{

		$this->title="Job Search";
		$this->tname="Jobs";		
		$this->sqlstr="SELECT id,job_name,job_desc from sierratec_jobs";
		
		$this->headers[0]="Job Id";
		$this->headers[1]="Job Name";
		$this->headers[2]="Job Desc";

		$this->align[0]="left";
		$this->align[1]="left";
		$this->align[2]="left";
		
		$this->datafields[0]="id";
		$this->datafields[1]="job_name";
		$this->datafields[2]="job_desc";

		$this->maxlength[0]=10;
		$this->maxlength[1]=20;
		$this->maxlength[1]=30;
		
		$this->orderbyfield="id";
		$this->order="asc";
	}

	function setapplicants() 
	{

		$this->title="Applicants Search";
		$this->tname="Applicants";		
		$this->sqlstr="SELECT a.*,b.job_name from sierratec_applicants a, sierratec_jobs b where a.job_id=b.id";
		
		$this->headers[0]="Applicant Id";
		$this->headers[1]="First Name";
		$this->headers[2]="Last Name";
		$this->headers[3]="Emailid";
		$this->headers[4]="Phone No.";
		$this->headers[5]="Date Submitted";
		$this->headers[6]="Job Applied";

		$this->align[0]="left";
		$this->align[1]="left";
		$this->align[2]="left";
		$this->align[3]="left";
		$this->align[4]="left";
		$this->align[5]="left";								
		$this->align[6]="left";								

		$this->datafields[0]="id";
		$this->datafields[1]="first_name";
		$this->datafields[2]="last_name";
		$this->datafields[3]="emailid";
		$this->datafields[4]="phone_no";
		$this->datafields[5]="date_submitted";						
		$this->datafields[6]="job_name";						

		$this->maxlength[0]=5;
		$this->maxlength[1]=15;
		$this->maxlength[2]=15;
		$this->maxlength[3]=10;
		$this->maxlength[4]=10;
		$this->maxlength[5]=5;								
		$this->maxlength[6]=5;										
	
		$this->orderbyfield="job_name";
		$this->order="asc";
	}
		
	function setsusbcribers() 
	{

		$this->title="Subscribers";
		$this->tname="Subscribers";		
		$this->sqlstr="SELECT * from sierratec_subscribers";
		
		$this->headers[0]="Subscriber Id";
		$this->headers[1]="Email Id";
		$this->headers[2]="Subscibed On";
		$this->headers[3]="Ip";
		
		$this->align[0]="left";
		$this->align[1]="left";
		$this->align[2]="left";
		$this->align[3]="left";		
		
		$this->maxlength[0]=10;
		$this->maxlength[1]=50;
		$this->maxlength[2]=50;
		$this->maxlength[3]=100;
				
		$this->datafields[0]="id";
		$this->datafields[1]="email_id";
		$this->datafields[2]="subscribed_date";
		$this->datafields[3]="ip";		
		
		$this->orderbyfield="id";
		$this->order="asc";
	}

	function setenquries() 
	{

		$this->title="Enquries";
		$this->tname="Enquries";		
		$this->sqlstr="SELECT * from sierratec_enquries";
		
		$this->headers[0]="Id";
		$this->headers[1]="Email Id";
		$this->headers[2]="Submitted Date";
		$this->headers[3]="Subject";		
		$this->headers[4]="Message";
		
		$this->datafields[0]="id";
		$this->datafields[1]="emailid";
		$this->datafields[2]="submitted_date";
		$this->datafields[3]="subject";		
		$this->datafields[4]="message";		
		
		$this->maxlength[0]=10;
		$this->maxlength[1]=10;
		$this->maxlength[2]=10;
		$this->maxlength[3]=30;		
		$this->maxlength[4]=70;
				
		$this->orderbyfield="id";
		$this->order="asc";
	}
	
	function setjobapplicants() 
	{

		$this->title="Applicants Search";
		$this->tname="Applicants";		
		$this->sqlstr="SELECT a.* from sierratec_postresume_applicants a";
		
		$this->headers[0]="Id";
		$this->headers[1]="First Name";
		$this->headers[2]="Last Name";
		$this->headers[3]="Email";
		$this->headers[4]="Mobile No.";
		$this->headers[5]="Job Code";
		$this->headers[6]="Submitted On";

		$this->align[0]="left";
		$this->align[1]="left";
		$this->align[2]="left";
		$this->align[3]="left";
		$this->align[4]="left";
		$this->align[5]="left";								
		$this->align[6]="left";								
		
		$this->datafields[0]="id";
		$this->datafields[1]="first_name";
		$this->datafields[2]="last_name";
		$this->datafields[3]="email";
		$this->datafields[4]="mobile";
		$this->datafields[5]="job_code";
		$this->datafields[6]="submitted_date";	

		$this->maxlength[0]=3;
		$this->maxlength[1]=15;
		$this->maxlength[2]=15;
		$this->maxlength[3]=10;
		$this->maxlength[4]=7;
		$this->maxlength[5]=5;	
		$this->maxlength[6]=40;	
	
		$this->orderbyfield="id";
		$this->order="desc";
	}
	
	function setxamarin() 
	{

		$this->title="MAUI";
		$this->tname="MAUI";		
		$this->sqlstr="SELECT * from sierratec_xamarin";
		
		$this->headers[0]="Id";
		$this->headers[1]="Name";
		$this->headers[2]="Email Id";
		$this->headers[3]="Phone";
		$this->headers[4]="Company";
		$this->headers[5]="Submitted Date";
		
		$this->align[0]="left";
		$this->align[1]="left";
		$this->align[2]="left";
		$this->align[3]="left";		
		$this->align[4]="left";		
		$this->align[5]="left";				
		
		$this->maxlength[0]=10;
		$this->maxlength[1]=50;
		$this->maxlength[2]=50;
		$this->maxlength[3]=50;
		$this->maxlength[4]=100;
		$this->maxlength[5]=50;		
		
		$this->datafields[0]="id";
		$this->datafields[1]="name";
		$this->datafields[2]="email";
		$this->datafields[3]="phone";
		$this->datafields[4]="company";
		$this->datafields[5]="submitted_date";	
		
		$this->orderbyfield="id";
		$this->order="asc";
	}
	
function setappointmentbooking() 
{
    $this->title = "Appointment Booking";
    $this->tname = "Appointment Booking";		
    $this->sqlstr = "SELECT * FROM sierratec_appointment_booking";

    $this->headers[0] = "Id";
    $this->headers[1] = "Name";
    $this->headers[2] = "Email Id";
    $this->headers[3] = "Phone";
    $this->headers[4] = "Company";
    $this->headers[5] = "Designation";
    $this->headers[6] = "City";
    $this->headers[7] = "Country";
    $this->headers[8] = "Preferred Date";
    $this->headers[9] = "Preferred Time";
    $this->headers[10] = "Message";
    $this->headers[11] = "Marketing Communication";
    $this->headers[12] = "Event";
    $this->headers[13] = "Submitted Date";

    $this->align[0] = "left";
    $this->align[1] = "left";
    $this->align[2] = "left";
    $this->align[3] = "left";		
    $this->align[4] = "left";		
    $this->align[5] = "left";		
    $this->align[6] = "left";		
    $this->align[7] = "left";		
    $this->align[8] = "left";		
    $this->align[9] = "left";		
    $this->align[10] = "left";		
    $this->align[11] = "left";		
    $this->align[12] = "left";		
    $this->align[13] = "left";		

    $this->maxlength[0] = 10;
    $this->maxlength[1] = 50;
    $this->maxlength[2] = 50;
    $this->maxlength[3] = 50;
    $this->maxlength[4] = 100;
    $this->maxlength[5] = 50;
    $this->maxlength[6] = 50;
    $this->maxlength[7] = 50;
    $this->maxlength[8] = 20;
    $this->maxlength[9] = 20;
    $this->maxlength[10] = 255;
    $this->maxlength[11] = 10;
    $this->maxlength[12] = 50;
    $this->maxlength[13] = 50;		

    $this->datafields[0] = "appt_id";
    $this->datafields[1] = "first_name";  // Updated from firstname to first_name
    $this->datafields[2] = "email";
    $this->datafields[3] = "phone";
    $this->datafields[4] = "company_name";
    $this->datafields[5] = "designation";
    $this->datafields[6] = "city";
    $this->datafields[7] = "country";
    $this->datafields[8] = "conv_date";  // Preferred Date
    $this->datafields[9] = "conv_time";  // Preferred Time
    $this->datafields[10] = "message";
    $this->datafields[11] = "opt_in";  // Marketing Communication
    $this->datafields[12] = "event";
    $this->datafields[13] = "submitted_date";

    $this->orderbyfield = "appt_id";
    $this->order = "asc";
}

function setEnquiries() 
{
    $this->title = "Enquiries Search";
    $this->tname = "Enquiries";
    
    $this->sqlstr = "SELECT id, site_source, form_source, name, mobile, email, website, company, designation, address, city, country, know_about_through, nature_of_business, modules_interested, other_modules, mode_of_usage, requirement, no_of_locations, no_of_users, geographies_interested, verticals_focussed_on, remarks, preferred_date, preferred_time, time_zone, ip_details, submitted_date, CONVERT_TZ(submitted_date, '+00:00', '+09:30') AS submitted_date_ist 
                     FROM sierratec_enquiries ";

    $this->headers[0] = "Enquiry ID";
    $this->headers[1] = "Site Source";
    $this->headers[2] = "Form Source";
    $this->headers[3] = "Name";
    $this->headers[4] = "Mobile";
    $this->headers[5] = "Email";
    $this->headers[6] = "Website";
    $this->headers[7] = "Company";
    $this->headers[8] = "Designation";
    $this->headers[9] = "Address";
    $this->headers[10] = "City";
    $this->headers[11] = "Country";
    $this->headers[12] = "Pincode"; // New header for Pincode
    $this->headers[13] = "How Did You Hear About Us";
    $this->headers[14] = "Nature of Business";
    $this->headers[15] = "Modules Interested";
    $this->headers[16] = "Other Modules";
    $this->headers[17] = "Mode of Usage";
    $this->headers[18] = "Requirement";
    $this->headers[19] = "No. of Locations";
    $this->headers[20] = "No. of Users";
    $this->headers[21] = "Geographies Interested";
    $this->headers[22] = "Verticals Focused On";
    $this->headers[23] = "Remarks";
    $this->headers[24] = "Preferred Date";
    $this->headers[25] = "Preferred Time";
    $this->headers[26] = "Time Zone";
    $this->headers[27] = "IP Details";
	$this->headers[28] = "IP Country Code";
	$this->headers[29] = "IP Country Name";
	$this->headers[30] = "IP Region Name";
	$this->headers[31] = "IP City";
	$this->headers[32] = "IP Zip Code";
	$this->headers[33] = "IP Time Zone";
    $this->headers[34] = "Date Submitted";
	$this->headers[35] = "Date Submitted IST";
    
    // Align all fields to the left
    for ($i = 0; $i < 36; $i++) {
        $this->align[$i] = "left";
    }

    $this->datafields[0] = "id";
    $this->datafields[1] = "site_source";
    $this->datafields[2] = "form_source";
    $this->datafields[3] = "name";
    $this->datafields[4] = "mobile";
    $this->datafields[5] = "email";
    $this->datafields[6] = "website";
    $this->datafields[7] = "company";
    $this->datafields[8] = "designation";
    $this->datafields[9] = "address";
    $this->datafields[10] = "city";
    $this->datafields[11] = "country";
    $this->datafields[12] = "pincode"; // New field for Pincode
    $this->datafields[13] = "know_about_through";
    $this->datafields[14] = "nature_of_business";
    $this->datafields[15] = "modules_interested";
    $this->datafields[16] = "other_modules";
    $this->datafields[17] = "mode_of_usage";
    $this->datafields[18] = "requirement";
    $this->datafields[19] = "no_of_locations";
    $this->datafields[20] = "no_of_users";
    $this->datafields[21] = "geographies_interested";
    $this->datafields[22] = "verticals_focussed_on";
    $this->datafields[23] = "remarks";
    $this->datafields[24] = "preferred_date";
    $this->datafields[25] = "preferred_time";
    $this->datafields[26] = "time_zone";
    $this->datafields[27] = "ip_details";
    $this->datafields[28] = "ip_country_code";
	$this->datafields[29] = "ip_country_name";
	$this->datafields[30] = "ip_region_name";
	$this->datafields[31] = "ip_city";
	$this->datafields[32] = "ip_zip_code";
	$this->datafields[33] = "ip_time_zone";
    $this->datafields[34] = "submitted_date";
	$this->datafields[35] = "submitted_date_ist";	
    
    $this->maxlength[0] = 5;
	$this->maxlength[1] = 20;
	$this->maxlength[2] = 20;
	$this->maxlength[3] = 50;
	$this->maxlength[4] = 15;
	$this->maxlength[5] = 30;
	$this->maxlength[6] = 50;
	$this->maxlength[7] = 30;
	$this->maxlength[8] = 30;
	$this->maxlength[9] = 100;
	$this->maxlength[10] = 30;
	$this->maxlength[11] = 30;
	$this->maxlength[12] = 10; // Pincode (adjustable to suit international formats)
	$this->maxlength[13] = 30;
	$this->maxlength[14] = 50;
	$this->maxlength[15] = 50;
	$this->maxlength[16] = 50;
	$this->maxlength[17] = 100;
	$this->maxlength[18] = 5;
	$this->maxlength[19] = 5;
	$this->maxlength[20] = 100;
	$this->maxlength[21] = 50;
	$this->maxlength[22] = 200;
	$this->maxlength[23] = 10;
	$this->maxlength[24] = 10;
	$this->maxlength[25] = 10;
	$this->maxlength[26] = 50;
	$this->maxlength[27] = 10;
	$this->maxlength[28] = 10;
	$this->maxlength[29] = 10;
	$this->maxlength[30] = 10;
	$this->maxlength[31] = 10;
	$this->maxlength[32] = 10;
	$this->maxlength[33] = 10;
	$this->maxlength[34] = 10; // Submitted Date (can be 10 characters for 'YYYY-MM-DD' format)
	$this->maxlength[35] = 10;
	
    $this->orderbyfield = "submitted_date";
    $this->order = "asc";
}


}
?>
