<?php
/* Code Revision:
* 26-08-2025:- The code to handle enquiries API
* 18-11-2025:- Updated the submitted date offset to +09:30 to +10:30
*/

header("Content-Type: application/json; charset=UTF-8");

// =====================
// 1. Define your API key
// =====================
$validApiKey = "mySecretToken123";

// =====================
// 2. Get API key from headers or query string
// =====================
$headers = function_exists('getallheaders') ? getallheaders() : [];
$apiKey = null;

if (isset($headers['X-API-KEY'])) {
    $apiKey = $headers['X-API-KEY'];
} elseif (isset($_GET['apikey'])) {
    $apiKey = $_GET['apikey'];
}

// =====================
// 3. Validate API key
// =====================
if ($apiKey !== $validApiKey) {
    http_response_code(401);
    echo json_encode(["error" => "Unauthorized"]);
    exit;
}

// =====================
// 4. Include DB connection file
// =====================
include_once("db_connection.php");  // your DB connection file

if (!$con) {
    http_response_code(500);
    echo json_encode(["error" => "Database connection failed"]);
    exit;
}

// =====================
// 5. Handle date filters
// =====================
$where = "WHERE id != ''";
$params = [];

if (!empty($_GET['start_date'])) {
    $start_date = mysqli_real_escape_string($con, $_GET['start_date']);
    $where .= " AND DATE(CONVERT_TZ(submitted_date, '+00:00', '+10:30')) >= '$start_date'";
}

if (!empty($_GET['end_date'])) {
    $end_date = mysqli_real_escape_string($con, $_GET['end_date']);
    $where .= " AND DATE(CONVERT_TZ(submitted_date, '+00:00', '+10:30')) <= '$end_date'";
}

// =====================
// 6. Fetch Data
// =====================
$sql = "SELECT id, site_source, form_source, name, mobile, email, website, company, designation, 
               address, city, country, pincode, know_about_through, nature_of_business, 
               modules_interested, other_modules, mode_of_usage, requirement, no_of_locations, 
               no_of_users, geographies_interested, verticals_focussed_on, remarks, 
               preferred_date, preferred_time, time_zone, ip_details, ip_country_code, 
               ip_country_name, ip_region_name, ip_city, ip_zip_code, ip_time_zone, 
               CONVERT_TZ(submitted_date, '+00:00', '+10:30') AS submitted_date 
        FROM sierratec_enquiries
        $where
        ORDER BY id DESC";

$result = mysqli_query($con, $sql);

$data = [];
if ($result && mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $data[] = $row;
    }
}

// =====================
// 7. Return JSON
// =====================
$response = [
    "status" => "success",
    "count"  => count($data),
    "data"   => $data
];

echo json_encode($response, JSON_PRETTY_PRINT);

mysqli_close($con);
?>